// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation 
// Illustrative Example 24.3 Page Number 352
// Title -  Paricle size of the charcoal
//========================================================================
model Ex24_3
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="lb/ft^3")=0.075  "Density of air";
    parameter Real meu(unit="lb/ft.s")=1.23E-5"Viscosity of the fluid";
    parameter Real v(unit="ft/s")=15          "Terminal settling Velocity ";
    parameter Real sg=2.2                     "Specific gravity";
    parameter Real g(unit="ft/s^2")=32.2      "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
    Real dp_stokes(unit="ft")                 "Diameter of the particle";
    Real K_stokes                             "Settling factor";
    Real dp(unit="ft")                        "Diameter of the particle";
    Real K                                    "Settling factor";
//============================================== 
//Equation Section
equation
//Assuming stokes law
  dp_stokes=((18*meu*v)/(g*sg*62.4))^0.5;//Converting sg to density of the particle
  K_stokes=dp_stokes*(((g*rho*sg*62.4)/(meu^2))^(1/3));//As K_stokes > 3.30 stokes law is not applicable assuming intermediate range
  (dp^1.14)=(v*(rho^0.29)*(meu^0.43))/(0.153*((g*sg*62.4)^0.71));
  K=K_stokes*dp/dp_stokes;//As 3.3<K<43.6 Intermidiate regime applies
end Ex24_3;
//========================================================================
