// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.8 Page Number 360
// Title - Separation of quartz
//========================================================================
model Ex24_8
//////Parameter section///////////////////////
//============================================
  parameter Real dp(unit="m")=9E-5         "Diameter of the large quartz particle";
  parameter Real g(unit="m/s^2")=9.807     "Acceleration due to gravity";
  parameter Real rho_s(unit="kg/m^3")=2650 "Density of quartz particle";
  parameter Real rho_f(unit="kg/m^3")=1000 "Density of the fluid";
  parameter Real meu_f(unit="kg/m.s")=0.001"Viscosity of the fluid";
  parameter Real Dp(unit="m")=4E-5         "Diameter of the smallest  galena particle";
  parameter Real rho_sm(unit="kg/m^3")=7500"Density of galena particle";
//============================================= 
///////Variable section///////////////////////////
 Real vq(unit="m/s")    "Terminal settling velocity of the quartz particle";
 Real vg(unit="m/s")     "Terminal settling velocity of the galena  particle";
 Real K                  "Settling factor for the largest quartz particle";
 Real Ks                 "Settling factor for the smallest galena particle";
 Real vw(unit="mm/s")     "upward velocity of water";
//============================================== 
//Equation Section
equation
  K=dp*(((g*(rho_s-rho_f)*rho_f)/(meu_f^2))^(1/3));//As K <3.3 Stokes Law is applied
  vq=(g*(dp^2)*(rho_s-rho_f))/(18*meu_f);
  Ks=Dp*(((g*(rho_sm-rho_f)*rho_f)/(meu_f^2))^(1/3));//As Ks <3.3 Stokes Law applies 
  vg=(g*(Dp^2)*(rho_sm-rho_f))/(18*meu_f);
  vw=vq*1000;//Conversion of m to mm.
end Ex24_8;
//============================================================================
