// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 25 Porous media and packed beds
// Illustrative Example 25.4 Page Number 373
// Title - Specific surface and Effective particle diameter
//========================================================================
model Ex25_4
//////Parameter section///////////////////////
//============================================
    parameter Real L(unit="in")=3/4            "Edge length of the particle";
//============================================= 
///////Variable section///////////////////////////    
    Real Vp(unit="in^3")                       "Volume of the particle";
    Real Sp(unit="in^2")                       "Surface area of the particle";
    Real ap(unit="in^-1")                      "specific  surface area";
    Real dpe(unit="in")                        "Effective particle diameter";
//============================================== 
//Equation Section    
equation
    Vp=L^3;
    Sp=6*L^2;
    ap=Sp/Vp;
    dpe=6/ap;
end Ex25_4;
//=========================================================================
