// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 25 Porous media and packed beds
// Illustrative Example 25.6 Page Number 375
// Title - Hydraulic diameter
//========================================================================
model Ex25_6
//////Parameter section///////////////////////
//============================================
    parameter Real dp(unit="ft")=0.0833    "Diameter of the particle";
    parameter Real e=0.4                   "Bed porosity";
//============================================= 
///////Variable section///////////////////////////
    Real Dh(unit="ft")                     "Hydralic diameter";
    Real rh(unit="ft")                     "hydralic radius";
//============================================== 
//Equation Section
equation
    Dh=(2/3)*(e/(1-e))*dp;
    rh=Dh/4;
end Ex25_6;
//=========================================================================
