//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.10 Page Number 395
// Title - Height of the bed
//========================================================================
model Ex26_10
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi "The value of pi";
    parameter Real db(unit="m")=0.2              "Diameter of the bed";
    parameter Real dp(unit="m")=7.4E-5           "Diameter of the particle";
    parameter Real Lmf(unit="m")=0.3             "Bed height at minimum fluidisation";
    parameter Real e_mf=0.45                     "Bed porosity at minimum fluidisation";
    parameter Real rho_s(unit="kg/m^3")=2200     "Density of the particles" ;
    parameter Real rho_f(unit="kg/m^3")=1.2      "Density of the fluid";
    parameter Real g(unit="m/s^2")=9.807         "Acceleration due to gravity";
    parameter Real muef(unit="kg/m.s")=1.89E-5   "Viscosity of the fluid";
    parameter Real vt(unit="m/s")=0.35           "Terminal settling velocity";
//============================================= 
///////Variable section///////////////////////////    
    Real e                                       "Porosity of the expanded bed";
    Real vmf(unit="m/s")                         "Minimum Fluidisation velocity";
    Real Lf(unit="m")                            "Expanded bed height";
    Real Lo(unit="m")                            "Zero porosity bed height";
    Real m(unit="kg")                            "Mass of the Bed ";
//============================================== 
//Equation Section    
equation
    Lo=Lmf*(1-e_mf);
    vmf=((e_mf^3)*g*(rho_s-rho_f)*(dp^2))/(150*(1-e_mf)*muef);//Assuming laminar flow
    vt=((e^3)*g*(rho_s-rho_f)*(dp^2))/(150*(1-e)*muef);
    Lf=Lo/(1-e);
    m=rho_s*pi*(db^2)*Lo;
end Ex26_10;
//============================================================================
