//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.2 Page Number 382
// Title - Superficial velocity
//========================================================================
model Ex26_2
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi   "The value of pi";
  parameter Real hl(unit="ft")=1.25              "Total height of the water";
  parameter Real g(unit="ft/s^2")=32.174         "Acceleartion due to gravity";
  parameter Real e=0.25                          "bed porosity";
  parameter Real dp(unit="ft")=0.00417           "Diameter of the particle";
  parameter Real L(unit="ft")=1.0                "pipe length";
  parameter Real rho(unit="lb/ft^3")=62.4        "Density of the fluid";
  parameter Real meu(unit="lb/ft.s")=6.76E-4     "Viscosity of the fluid";
  parameter Real D(unit="ft")=0.167              "Diameter of the pipe";
//============================================= 
///////Variable section///////////////////////////
  Real vs_tur(unit="ft/s")                       "superficial velocity if turbulent";
  Real hf(unit="ft")                             "Loss due to friction";
  Real R_e_p                                     "Renyolds number for turbulent flow assumption";
  Real Re_p                                      "Renyolds number for the laminar flow assumption";
  Real vs_lam(unit="ft/s")                       "superficial velocity if laminar"; 
  Real S(unit="ft^2")                            "Cross sectional area";
  Real q(unit="ft^3/s")                          "Volumetric flow rate";  
//============================================== 
//Equation Section              
equation
  hf=hl;
  vs_tur=((g*hf*(e^3)*dp)/(1.75*(1-e)*L))^0.5;//Assume turbulent flow
  R_e_p=(dp*vs_tur*rho)/((1-e)*meu);//As R_e_p <1000 The flow is not turbulent and assuming laminar flow
  vs_lam=(rho*g*hl*(e^3)*(dp^2))/(150*meu*((1-e)^2)*L);
  Re_p=(dp*vs_lam*rho)/((1-e)*meu);//As Re_p <10 The flow is laminar
  S=(pi*(D^2))/4;
  q=S*vs_lam;
end Ex26_2;
//============================================================================
