//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.6 Page Number 392
// Title - Pressure drop 
//========================================================================
model Ex26_6
//////Parameter section///////////////////////
//============================================
    parameter Real rho_s(unit="lb/ft^3")=84                  "Density of the coal particle";
    parameter Real rho_f(unit="lb/ft^3")=55                  "Density of oil";
    parameter Real e_mf=0.38                                 "Void fraction";
    parameter Real L_mf(unit="ft")=8                         "Height of the bed at minimum fluidisation";
//============================================= 
///////Variable section///////////////////////////    
    Real DelP(unit="psf")                                    "Pressure drop required for fluidisation";
//============================================== 
//Equation Section    
equation
  DelP=((rho_s-rho_f)*(1-e_mf)*L_mf)+(rho_f*L_mf);//As it is an upflow of fluid (+) has to be used in the expression.
end Ex26_6;
//============================================================================
