//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.7 Page Number 392
// Title - Volumetric flow rate of the fluid
//=====================================================================
model Ex26_7
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi "The value of pi";
  parameter Real D(unit="ft")=4                "Diameter of the bed";
  parameter Real dp(unit="ft")=0.00137         "Diameter of the particle";
  parameter Real rho_s(unit="lb/ft^3")=84      "Desnity of the coal particle";
  parameter Real rho_f(unit="lb/ft^3")=55      "Density of the fluid";
  parameter Real meu(unit="lb/ft.s")=3.13E-4   "Viscosity of the oil";
  parameter Real e_mf=0.38                     "Void fraction";
  parameter Real Lmf(unit="ft")=8              "Height of the bed at minimum fluidisation";
  parameter Real Lf(unit="ft")=10              "Height of the bed";
  parameter Real g(unit="ft/s^2")=32.174       "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////  
  Real e                "Bed voidage";
  Real q(unit="ft^3/s") "Volumetric flow rate";
  Real Re               "Reynolds number";
  Real vs(unit="ft/s")  "Superficial velocity";
//============================================== 
//Equation Section
equation
   Lf=(Lmf*(1-e_mf))/(1-e);
  vs=((e^3)*g*(rho_s-rho_f)*(dp^2))/(150*(1-e)*meu);
  q=(pi*(D^2)*vs)/4;
  Re=(dp*vs*rho_f)/(meu*(1-e));//As Re<10 The flow is laminar 
end Ex26_7;
//Remark:The answer provided for Re in the textbook is wrong as the value of meu is taken as 0.01 instead of 3.3E-4 lb/ft.s
//============================================================================
