//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.8 Page Number 393
// Title - Pressure of the inlet gas.
//=====================================================================
model Ex26_8
//////Parameter section///////////////////////
//============================================
    parameter Real vs(unit="ft/s")=2         "Superficial velocity";
    parameter Real e=0.4                     "Bed porosity";
    parameter Real L(unit="ft")=50           "Length of the bed";
    parameter Real dp(unit="ft")=0.0833      "Diameter of the particle";
    parameter Real g(unit="ft/s^2")=32.174   "Acceleration due to gravity";
    parameter Real P2(unit="psf")=4320       "Pressure at the bottom of the bed";
    parameter Real fpm=1.75                  "Porous medium factor by Equation 26.6";
    parameter Real rho_f(unit="lb/ft^3")=0.0128"Density of the fluid";
    parameter Real zd(unit="ft")=-50         "Difference in height from point 2 to point 1";
    parameter Real v(unit="ft/s")=5          "Interstitial Velocity ";
//============================================= 
///////Variable section///////////////////////////     
    Real hf(unit="ft")                        "Head Loss";
    Real P1(unit="psf")                       "Pressure at the inlet";
    Real v_2g(unit="ft")                      "Dyanamic Head";
//============================================== 
//Equation Section    
equation
    hf=(1.75*(vs^2)*(1-e)*L)/(g*(e^3)*dp);
    v_2g=v^2/(2*g);//As v_2g<<hf The assumption is justified that we can neglect the dynamic head.
    P1=P2+(rho_f*(zd+hf));//Applying Bernoulli at the entrance and exit.
//As Permeability of the medium cannot be calculated as the flow is turbulent.
end Ex26_8;
// Remark:The answer provided in the textbook for v^2/2g is wrong.Calculation error.
//============================================================================
