//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.9 Page Number 394 
// Title - Pressure drop in a packed bed
//========================================================================
model Ex26_9
//////Parameter section///////////////////////
//============================================
    parameter Real Re=1000                 "Reynold number at turbulent flow";
    parameter Real dp(unit="m")=0.001      "Dimater of the particle";
    parameter Real meu(unit="kg/m.s")=0.001"Viscosity of the fluid";
    parameter Real e=0.25                  "Bed Porosity";
    parameter Real rho(unit="kg/m^3")=1000"Density of water";
    parameter Real L(unit="m")=0.5         "Length of the bed";
//============================================= 
///////Variable section///////////////////////////    
    Real DelP(unit="Pa")"Pressure drop";
    Real vs(unit="m/s")"Superficial velocity";
//============================================== 
//Equation Section
equation
    vs=(Re*meu*(1-e))/(dp*rho);
    DelP=(1.75*rho*L*(vs^2)*(1-e))/(dp*(e^3));
end Ex26_9;
//============================================================================
