// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 27 Filtration
// Illustrative Example 27.2 Page Number 413
// Title - Area of the filter cloth
//========================================================================
model Ex27_2
//////Parameter section///////////////////////
//============================================
    parameter Real m_slurry(unit="lb/min")=600        "Mass flow rate of slurry";
    parameter Real a(unit="h.ft^2/lb")=1/5               "1 ft^2 filter cloth area to treat 5 lb/h of solid";
    parameter Real masspercent=0.1 "10% of the solid is present in the slurry";
//============================================= 
///////Variable section///////////////////////////  
    Real m_solids(unit="lb/h")                         "Solid flow rate in the slurry";
    Real A(unit="ft^2")                                "Filter cloth area ";
//============================================== 
//Equation Section 
equation
    m_solids=masspercent*m_slurry*60;//Converting min to h
    A=a*m_solids;
end Ex27_2;
//============================================================================
