// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.10 Page Number 438
// Title - Compliance stack test
//========================================================================
model Ex28_10
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi    "The value of pi";
    parameter Real C=0.85                           "Pitot tube factor";
    parameter Real g(unit="m/s^2")=9.81             "Acceleration due to gravity";
    parameter Real rho1(unit="kg/m^3")=1000         "Density of manometer fluid";
    parameter Real rho(unit="kg/m^3")=1.084         "Density of flue gas";
    parameter Real h(unit="in H2O")=0.3772          "Mean pitot reading";
    parameter Real m(unit="g")=0.16                 "Mass of the particulate";
    parameter Real V(unit="dscf")=35                "Volume sampled";
    parameter Real D(unit="ft")=2                   "Diameter of the stack";
    parameter Real w_mo=0.07                        "% moisture in stack gas";
    parameter Real T_s(unit="degR")=530             "Standard Temperature";
    parameter Real P_s(unit="psi")=29.9             "Standard pressure";
    parameter Real P_g(unit="psi")=29.6             "Pressure of stack gas";
    parameter Real T_g(unit="degR")=600             "Temperature of stack gas";
    parameter Real w_CO2=0.14                       "% of C2O";
    parameter Real w_N2=0.79                        "% of N2";
    parameter Real w_H2O=0.07                       "% of H20";
    parameter Real w_O2=0.07                        "% of O2";
    parameter Real w_other=0.93                     "% of Other components" ;
    parameter Real MW_O(unit="lb/lbmol")=32         "Molecular weight of O2";
    parameter Real MW_CO2(unit="lb/lbmol")=44       "Molecular weight of CO2";
    parameter Real MW_N2(unit="lb/lbmol")=28        "Molecular weight of N2";
    parameter Real MW_H2O(unit="lb/lbmol")=18       "Molecular weight of H2O";
    parameter Real MW_other(unit="lb/lbmol")=30.52  "Molecular weight of other components";
//============================================= 
///////Variable section///////////////////////////    
    Real MW_w(unit="lb/lbmol")                      "Wet basis molecular weight of the flue gas";
    Real MW_d(unit="lb/lbmol")                      "Dry basis molecular weight of the flue gas";
    Real PC(unit="gr/dscf")                         "Particulate concentration";
    Real v(unit="fps")                              "Velocity";
    Real vol_stack(unit="acfs")                     "Stack flow rate";
    Real vol_dry(unit="dacfm")                      "Dry volumetric rate";
    Real vol_std(unit="dscfm")                      "standard olumetric flow rate ";
    Real PER(unit="lb/day")                         "Particulate emission rate";
//============================================== 
//Equation Section    
equation
    PC=m*15.43/V;
    v=(C*(((2*g*rho1*0.0254*h)/rho)^0.5))*3.28084;//Coversion of m to ft
    vol_stack=v*pi*(D^2)/4;
    vol_dry=(1-w_mo)*vol_stack*60;
    vol_std=vol_dry*(T_s/T_g)*(P_g/P_s);
    PER=PC*vol_std*(1440/7000);//Converting gr to lb and min to day
//Calculating the Molecular weight of the flue gas on dry ad wet basis
    MW_d=(w_O2*MW_O )+(w_CO2*MW_CO2)+(w_N2*MW_N2);
    MW_w=(w_H2O*MW_H2O)+(w_other*MW_other);
end Ex28_10;
//=========================================================================
