// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.11 Page Number 440
// Title - Perchloroehthylene in a degreasing operation
//========================================================================
model Ex28_11
//////Parameter section///////////////////////
//===========================================
  parameter Real Feed(unit="lb")=1                                "Fresh Feed Amount" ;
  parameter Real Input(unit="lb")=1                               "Input to the system";
  parameter Real EF[3](each unit="lb PCE released/lb PCE entering")={0.78,0.60,0.4} "Emission factor";
//============================================= 
///////Variable section///////////////////////////
  Real Input_tank[3](each unit="lb")                             "Input to the tank";
  Real Output_tank[3](each unit="lb")                            "Output from the tank";
  Real X[3](each unit="lb")                                      "Variable to determine unknown";
  Real PCE[3](each unit="lb PCE emitted/lb fresh PCE ")          "PCE emissions";
  Real SpentPCE[3](each unit="lb")                               "Spent PCE";
  Real Input_solvent[3](each unit="lb")                          "Input to the solvent recovery unit";
  Real RecyclePCE[3](each unit="lb")                             "Recovered PCE";
  Real RejectPCE[3](each unit="lb")                              "Reject PCE";
  Real Output_solvent[3](each unit="lb")                         "Output from the solvent recovery unit";
  Real Output[3](each unit="lb")                                 "Output from the system";
//============================================== 
//Equation Section
equation
for i in 1:3 loop
//Mass balance around the tank
    Input_tank[i]=Feed+X[i];
    Output_tank[i]=PCE[i]+SpentPCE[i];
    SpentPCE[i]=(1-EF[i])*(1+X[i]);
    PCE[i]=EF[i]*(1+X[i]);
//Mass Balance around the solvent recovery unit
    Input_solvent[i]=SpentPCE[i];
    Output_solvent[i]=RecyclePCE[i]+RejectPCE[i];
    RecyclePCE[i]=0.75*SpentPCE[i];//As Recycle is 75% of the spent PCE
    RejectPCE[i]=0.25*SpentPCE[i];
//Mass Balance around the entire system
    Output[i]=PCE[i]+RejectPCE[i];
    Input=Output[i];
end for;
//Remark: The PCE Emission results is shown in Table 28.4.
end Ex28_11;
//=========================================================================
