// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.6 Page Number 434
// Title - Manning equation
//========================================================================
model Ex28_6
//////Parameter section///////////////////////
//============================================
    parameter Real Ibase(unit="ft")=20               "Length at the bottom base";
    parameter Real Itop(unit="ft")=50                "Length of the top base";
    parameter Real h(unit="ft")=7.5                  "Height of channel";
    parameter Real S=0.0008                          "Channel bottom slope";
    parameter Real n=0.02                            "Roughness Coefficient";
//============================================= 
///////Variable section///////////////////////////    
    Real A(unit="ft^2")                              "Cross sectional area available";
    Real P(unit="ft")                                "Wetted perimeter";
    Real rh(unit="ft")                               "Hydralic radius";
    Real q(unit="ft^3/s")                            "Volumetric flow rate";
//============================================== 
//Equation Section    
equation
    A=(Ibase+Itop)*(h/2);
    P=Ibase+(((h^2)+((2*h)^2))^0.5);
    rh=A/P;
    q=(1.486*A*(rh^(2/3))*(S^0.5))/n;
end Ex28_6;
//Remark: The answers may slightly vary due to  rounding off values
//=========================================================================
