// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.7 Page Number 435
// Title - Total nitrogen discharged due to run off.
//========================================================================
model Ex28_7
//////Parameter section///////////////////////
//============================================
    parameter Real qw(unit="MGD")=10          "Volumetric flow rate discharged";
    parameter Real C(unit="mg/L")=35          "Nitrogen Concentration that is being discharged";
    parameter Real S(unit="mi^2")=8           "Watershed area";
    parameter Real r(unit="mL/day")=0.06      "Rainfall rate";
    parameter Real n=0.5                      "Percentage Rain that is recievd in the sewers";
    parameter Real Cr(unit="mg/L")=9           "Nitrogen concentration in the runoff";
    parameter Real rho(unit="lb/ft^3")=62.4   "Density of water";
//============================================= 
///////Variable section///////////////////////////     
    Real mw(unit="lb/day")                    "Total N2 discharge from plant";
    Real q(unit="ft^3/s")                     "Volumetric flow rate";
    Real mr(unit="lb/day")                    "Total N2 discharge from runoff";
//============================================== 
//Equation Section    
equation
    mw=C*qw*8.34;//Converting L to gal and g to lb
    q=n*r*S*(5280^2)/(3600*12);
    mr=q*Cr*3600*24*rho/(10^6);//Conversion from s to day
end Ex28_7;
//Remark: The answers may slightly vary due to  rounding off values
//=========================================================================
