// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 29 Accident and emergency management
// Illustrative Example 29.3 Page Number 455
// Title - Diameter of the duct and power requirement
//========================================================================
model Ex29_3
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi             "The value of pi";
    parameter Real vair(unit="ft/min")=4000                  "Minimum air velocity";
    parameter Real n=4                                       "Number of work stations";
    parameter Real q(unit="acfm")=3000                       "Volumetric flow rate of air";
    parameter Real rho(unit="lb/ft^3")=0.075                 "Density of the fluid";
    parameter Real meu(unit="lb/ft.s")=1.21E-5               "Viscosity of the fluid";
    parameter Real f=0.003                                   "Fanning friction factor";
    parameter Real L(unit="ft")=400                          "Duct length";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.2             "Unit conversion factor";
    parameter Real neta=0.4                                  "Efficiency";
    parameter Real DelP_h(unit="inH2O")=0.5                  "Pressure drop in the hood";
    parameter Real DelP_c(unit="inH2O")=3.5                  "Pressure drop in the cyclone cleaner";
//============================================= 
///////Variable section///////////////////////////       
    Real DelP_t(unit="lbf/ft^2")                             "Total pressure drop";
    Real qair(unit="acfm")                                   "Total volumetric flow rate" ;
    Real D(unit="ft")                                        "Duct Diameter";
    Real Re                                                  "Reynolds number";
    Real hp(unit="hp")                                       "Power required in hp";
    Real A(unit="ft^2")                                      "Cross sectional area";
    Real DelP_d(unit="lbf/ft^2")                             "Pressure drop in the duct";
    Real v_air(unit="ft/s")                                  "Velocity of air";
//============================================== 
//Equation Section    
equation
    v_air=vair/60;//Conversion of min to s.
    qair=n*q;
    A=qair/(60*v_air);
    D=(4*A/pi)^0.5;
    Re=(D*rho*v_air)/meu;
    DelP_d=(4*f*L*(v_air^2)*rho)/(2*gc*D);
    DelP_t=(DelP_c*5.2)+(DelP_h*5.2)+DelP_d;//Conversion of inH2O to lbf/ft^2
    hp=(DelP_t*qair/neta)*3.03E-5;
end Ex29_3;
//============================================================================
