// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 29 Accident and emergency management
// Illustrative Example 29.7 Page Number 461
// Title -  CSTR Reactor
//========================================================================
model Ex29_7
//////Parameter section///////////////////////
//============================================
    parameter Real v(unit="m^3")=1100          "Volume of reactor";
    parameter Real T(unit="K")=295             "Temperature of the reactor";
    parameter Real v_s(unit="m^3")=0.0224      "Volume of the 1 gmol of air at STP";
    parameter Real T_s(unit="K")=273           "Standard Temperature";
    parameter Real v_r(unit="gmol")=0.75       "Hydrocarbon emitted";
//============================================= 
///////Variable section///////////////////////////    
    Real n_air(unit="gmoles")                  "Total gmoles of air";
    Real x_hc(unit="ppb")                      "Mole fraction of hydrocarbon";
//============================================== 
//Equation Section    
equation
    n_air=(v/v_s)*(T_s/T);
    x_hc=(v_r/(n_air+v_r))*10^9;//Converting to ppb
end Ex29_7;
//============================================================================
