// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 3 Key Terms and Definitions 
// Illustrative Example 3.5 Page Number 30
// Title - Potential energy of water
//========================================================================
model Ex3_5
//////Parameter section///////////////////////
//============================================
    parameter Real m(unit="kg")=1       "Mass of the fluid";
    parameter Real g(unit="m/s^2")=9.8  "Accelaration due to gravity";
    parameter Real z2(unit="m")=10      "Height above the ground level";
    parameter Real PE1(unit="J")=0      "Assuming potential Energy at the ground level";
//============================================= 
///////Variable section///////////////////////////
    Real PE2(unit="J")                  "Potential Energy at 10 m height";
    Real DelPE(unit="J")                "Potential Energy difference";
//============================================== 
//Equation Section
equation
    DelPE=PE2-PE1;
    PE2=m*g*z2;
end Ex3_5;
//============================================================================
