// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 33 Biomedical Engineering
// Illustrative Example 33.2 Page Number 525
// Title - Units of pressure
//========================================================================
model Ex33_2
//////Parameter section///////////////////////
//============================================
  parameter Real P(unit="mmHg")=80        "Given Cardiovascular pressure";
//============================================= 
///////Variable section///////////////////////////
  Real P_inHg(unit="in Hg")                          "Pressure in inches of Hg";
  Real P_ftH2O(unit="ft H2O")                        "Pressure in ft of H2O";
  Real P_inH2O(unit="in H2O")                        "Pressure in inches of H2O";
  Real P_psia(unit="psia")                           "Pressure in psia";
  Real P_psfa(unit="psfa")                           "Pressure in psfa";
  Real P_Nm2(unit="N/m^2")                           "Pressure in N/m^2";
//============================================== 
//Equation Section
equation
  P_inHg=P*(29.92/760);//As 760 mmHg = 29.92 inHg
  P_ftH2O=P*(33.91/760);//As 760mmHg =33.91 ftH2O
  P_inH2O=P_ftH2O*12;//As 1 ft= 12 in
  P_psia=P*(14.7/760);//As 760 mmHg=14.7 psia
  P_psfa=P*(2116/760);//As 760 mmHg=2116 psfa
  P_Nm2=P*(1.013*(10^5))/760;//As 760 mmHg =1.013E5 N/m^2
end Ex33_2;
//Remark: The book answers have  been rounded off.
//========================================================================
