// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 33 Biomedical Engineering
// Illustrative Example 33.7 Page Number 531
// Title - Average velocity of blood
//========================================================================
model Ex33_7
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi           "The value of pi";
    parameter Real D(unit="cm")=2.5                        "Diameter of the aorta";
    parameter Real q(unit="cm^3/s")=93.3                   "Volumetric flow rate";
//============================================= 
///////Variable section///////////////////////////
    Real S(unit="cm^2")                                    "Cross sectional area";
    Real v(unit="cm/s")                                    "Average velocity of blood";
//============================================== 
//Equation Section  
equation
    S=(pi/4)*(D^2);
    v=q/S;
end Ex33_7;
//========================================================================
