// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 7 Conservation Law For Mass
// Illustrative Example 7.4 Page Number 67
// Title - Fraction of liquid to bypass the control device
//========================================================================
model Ex7_4
//////Parameter section///////////////////////
//============================================
  parameter Real lpoll(unit="ppm")=600          "Pollutant present in the liquid";
  parameter Real lperm(unit="ppm")=50           "Permissible amount of the pollutant in discharge";
//============================================= 
///////Variable section///////////////////////////
  Real  B                                       "Fration of liquid bypassed";
//============================================== 
//Equation Section
equation
//Basis : 1 lb of feed is fed into the control device.
  (1-B)*(0)+(lpoll*B)=lperm*1.0;//By performing Pollutant Mass Balance around point 2 in Fig 7.5
end Ex7_4;
//============================================================================
