// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 7 Conservation Law For Mass
// Illustrative Example 7.5 Page Number 67
// Title - Level of water in the tank.
//========================================================================
model Ex7_5
//////Parameter section///////////////////////
//============================================
    final constant Real pi= Modelica.Constants.pi        "The value of pi";
    parameter Real Din(unit="m")=0.09                    "Diameter of the inlet pipe";
    parameter Real vin(unit="m/s")=4                     "Velocity of the fluid at the inlet";
    parameter Real vout(unit="m/s")=3                    "Velocity of the fluid at the outlet";
    parameter Real Dout(unit="m")=0.04                   "Diameter of the outlet pipe";
    parameter Real D(unit="m")=1.4                       "Diameter of the tank";
//============================================= 
///////Variable section///////////////////////////    
    Real S(unit="m^2")                                   "Cross sectional area ";
    Real qout(unit="m^3/s")                              "Volumetric flow rate at outlet";
    Real qin(unit="m^3/s")                               "Volumetric flow rate at inlet";
    Real dz_dt(unit="m/s")                               "Rate of water level rise in the tank";
//============================================== 
//Equation Section
equation
    qin=pi*(Din^2)*vin/4;
    qout=pi*(Dout^2)*vout/4;
    S=pi*(D^2)/4;
    dz_dt=(qin-qout)/S;//As it is positive the water level is rising in the tank from its intial height   
end Ex7_5;
//============================================================================
