// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 9  Conservation Law For Momentum
// Illustrative Example 9.3 Page Number 88
// Title - Maximum flow rate
//========================================================================
model Ex9_3
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi         "The value of pi";
    parameter Real rho(unit="lb/ft^3")=62.4              "Density of the fluid";
    parameter Real D(unit="ft")=0.167                    "Diameter of the pipe" ;
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.174       "Conversion constant";
    parameter Real Mout(unit="lbf")=0                    "Horizontal momentum for outlet";
    parameter Real Fx(unit="lbf")=5                      "Force in x direction";
//============================================= 
///////Variable section///////////////////////////    
    Real Min(unit="lbf")                                 "Horizontal momentum for inlet"; 
    Real S(unit="ft^2")                                  "Cross sectional area";
    Real v(unit="ft/s")                                  "Velocity of the fluid";
    Real q(unit="ft^3/s")                                "Volumetric flow rate";
    Real m(unit="lb/s")                                  "Mass flow rate";
//============================================== 
//Equation Section
equation
    Min=Mout+Fx;//Linear momentum balance is applied in the x direction is applied
    S=pi*(D^2)/4;
    v^2=(Min*gc)/(rho*S);
    q=S*v;
    m=rho*q;
end Ex9_3;
//============================================================================


