// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 9  Conservation Law For Momentum
// Illustrative Example 9.4 Page Number 89
// Title - Velocity of the fluid from the hose
//========================================================================
model Ex9_4
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi        "The value of pi";
    parameter Real rho(unit="kg/m^3")=1000              "Density of the fluid";
    parameter Real q(unit="m^3/s")=0.025                "Volumetric flow rate";
    parameter Real D1(unit="m")=0.1                     "Diameter of hose";
    parameter Real D2(unit="m")=0.03                    "Diameter at section 2";
//============================================= 
///////Variable section///////////////////////////
    Real m2(unit="kg/s")                                "Mass flow rate at point 2";
    Real m1(unit="kg/s")                                "Mass flow rate at point 1";
    Real M1x(unit="N")                                  "Momentum rate in x direction at section 1";
    Real M2x(unit="N")                                  "Momentum rate in x direction at section 2";
    Real P1(unit="Pag")                                 "Pressure at point 1";
    Real S1(unit="m^2")                                 "Cross sectional area at section 1";
    Real S2(unit="m^2")                                 "Cross sectional area at section 2";
    Real v1(unit="m/s")                                 "Velocity at section 1";
    Real v2(unit="m/s")                                 "Velocity at section 2";
    Real Fx(unit="N")                                   "Force in the x direction";
//============================================== 
//Equation Section
equation
    m1=rho*q;
    m1=m2;
    S1=pi*(D1^2)/4;
    S2=pi*(D2^2)/4;
    v1=q/S1;
    v2=q/S2;
    P1=(rho/2)*(v2^2-v1^2);//Bernoulli's equation is applied between points 1 and 2 where z1=z2 and P2=0 Pag 
    M1x=m1*v1;
    M2x=m2*v2;
    Fx=M2x-M1x-(P1*S1);
end Ex9_4;
//Remark: The answers may slightly vary due to  rounding off values
//============================================================================


