//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.5 Page 9
//Title: To determine the force, pressure, work done and  potential energy
//===================================================

package Ex1_5

model Ex1_5_a

//============
//Library Section
extends Modelica.Constants;

//============
//Parameter Section
parameter Real m(unit = "kg") = 50 "Mass and weight of the piston" ;
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
parameter Real P(unit = "bar") = 1.01325 "Atmospheric pressure";
parameter Real d(unit = "mm") = 100 "Diameter of the piston";

//============
//Variable Section
Real FA(unit = "N") "Force exerted by the atmosphere";
Real FP(unit = "N") "Force exerted by the piston and weight";
Real TF(unit = "N") "Total force acting on the gas";

//============
//Equation Section
equation
FA = P*10^5*(pi/4)*(d/10^3)^2;    //Diameter is converted from mm to m
FP = m*g;
TF = FA + FP; 

end Ex1_5_a;

//============

model Ex1_5_b

extends Ex1_5_a;

//============
//Variable section
Real PG(unit = "N/m^2") "Pressure of the gas";

//============
//Equation Section
equation
PG = TF/((pi/4)*(d/10^3)^2);

end Ex1_5_b;

//============

model Ex1_5_c

extends Ex1_5_a;

//============
//Parameter Section
parameter Real D(unit = "mm") = 400 "Displacement due to expansion of gas";

//============
//Variable Section
Real W(unit = "J") "Work done by the gas";

//============
//Equation Section
equation
W = TF*(D/10^3);    //Displacement is converted from mm to m

end Ex1_5_c;

//============

model Ex1_5_d

extends Ex1_5_c;

//============
//Variable Section
Real deltaPE(unit = "J") "Change in potential energy of piston and weight after expansion";

//============
//Equation Section
equation
deltaPE = m*g*(D/10^3);   //Displacement is converted from mm to m

end Ex1_5_d;

//============

end Ex1_5;

//===================================================
