//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 1: Introduction and Basic Concepts
//Example: 1.8 Page 20
//Title: Calculation of work done by the gas
//===================================================

model Ex1_8

//============
//Parameter Section
parameter Real IV(unit = "m^3") = 0.2 "Initial volume of the gas";
parameter Real IP(unit = "bar") = 1 "Initial pressure of the gas";
parameter Real FP(unit = "bar") = 7 "Final pressure of the gas";

//============
//Variable Section
Real b(unit = "kPa") "Constant in the pressure relation";
Real FV(unit ="m^3") "Final volume of the gas";
Real W(unit = "kJ") "Work done by the gas";

//============
//Equation Section
equation
IP*10^2 = 1200*IV+b;    //Pressure is converted from bar to kPa
FP*10^2 = 1200*FV+b;    //Pressure is converted from bar to kPa
W = ((1200/2)*(FV^2-IV^2))-140*(FV-IV);    //Expression after integration

end Ex1_8;

//===================================================
