//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.1 Page 27
//Title: Change in internal energy
//===================================================

model Ex2_1

//============
//Parameter Section
parameter Real W(unit = "hp") = -2.25 "Work done on the system";
parameter Real Q(unit = "kJ/h") = -3400 " Heat transferred to the surrounding";

//============
//Variable Section
Real delta_U(unit = "J/s") "Change in internal energy";

//============
//Equation Section
equation
delta_U = ((Q*10^3)/3600)-(W*745.7);  //Conversion of kJ/hr to J/s and hp to J/s 
                                        // First law of thermodynamics delta_U = Q-W

end Ex2_1;

//===================================================
