//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.10 Page 33
//Title: Final temperature of the steam
//===================================================

model Ex2_10

//=============
//Parameter Section
parameter Real m(unit = "kg") = 0.1 "Mass of sat. water vapour";
parameter Real p(unit = "kPa") = 400 "Pressure";
parameter Real I(unit = "A") = 0.2 "Electric current";
parameter Real V(unit = "V") = 230 "Voltage";
parameter Real t(unit = "min") = 10 "Time";
parameter Real Ql(unit = "kJ") = -15.41 "Heat loss from the system";
parameter Real H1(unit = "kJ/kg") = 2738.6 "Initial enthalpy of the system";   
                                               //From steam tables(sat. steam), the enthalpy  at 400 kPa.

//============
//Variable Section
Real Qs(unit = "kJ") "Heat supplied by means of electric heater";
Real Q(unit = "kJ") "Net heat supplied";
Real delta_H(unit = "kJ/kg") "Enthalpy of the system";
Real H2(unit = "kJ/kg") "Final enthalpy of the system";

//============
//Equation Section
equation
Qs = (V*I*t*60)/10^3;   //Converting min to sec and J to kJ
Q = Ql+Qs;
delta_H = Q/m;
H2 = delta_H+H1;

//The enthalpy of super heated steam at 400kPa is 2860.5 kJ/kg
//From superheated steam table, the temperature at this condition is  found to be 473.15 K

end Ex2_10;

//===================================================
