//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.15 Page 38
//Title: Exit temperature of the steam
//===================================================

model Ex2_15

//===============
//Parameter Section
parameter Real m1(unit = "kg/s") = 5 "Inlet mass flow rate of steam";
parameter Real v2(unit = "m/s") = 300 "Velocity of inlet steam";
parameter Real A1(unit = "m^2") = 0.02 "Inlet area of nozzle";
parameter Real Q(unit = "kJ/kg") = -3.3 "Heat losses from the nozzle";
parameter Real V1(unit = "m^3/kg") = 0.16847 "Specific volume of inlet steam"; /*From superheated steam property tables corresponding to P1 = 1800 kPa and T1 = 673.15 K */
parameter Real H1(unit = "kJ/kg") = 3250.9 "Enthalpy at the inlet of nozzle";  /*From superheated steam property tables corresponding to P1 = 1800 kPa and T1 = 673.15 K */

//============
//Variable Section
Real v1(unit = "m/s") "Velocity of outlet steam";
Real delta_KE(unit = "kJ/kg") "Change in kinetic energy";
Real H2(unit = "kJ/kg") "Enthalpy at the outlet of the nozzle";

//============
//Equation Section
equation
//delta_PE is zero, since the inlet and exit of the nozzle are assumed to be at the same level
//Ws is zero, since no work is exchanged
v1 = (m1*V1)/A1;    // m1 = v1*A1*(1/V1)
delta_KE = (1/2*(v2^2-v1^2))/10^3;    
H2 =Q-delta_KE+H1;    //delta_H+delta_KE+delta_PE = Q-Ws
//From steam Tables, temperature for P2 = 1400 kPa and H2 = 3203.5 kJ/kg is 648.15 K
 
end Ex2_15;

//===================================================
