//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.16 Page 41
//Title: Heat transfer rate in the coils
//===================================================

model Ex2_16

//=============
//Parameter Section
parameter Real T1(unit = "K") = 293 "'Initial temperature of hydrogen gas";
parameter Real T2(unit = "K") = 453 "Temperature after heating the gas";
parameter Real delta_P(unit = "kPa") = 300 "Pressure drop in the coil";
parameter Real P2(unit = "kPa") = 136.8 "Pressure in the reactor";
parameter Real Cp(unit = "J/kmol K") = 29.4 "Heat capacity of hydrogen at constant pressure"; 
                                                            //Given as kJ/kmol in question, actual unit is J/kmol K
parameter Real m(unit = "kg") = 1000 "Mass of hydrogen";
parameter Real M(unit = "kg/kmol") = 2.02 "Molar mass of hydrogen";

//============
//Variable Section
Real delta_H1(unit = "kJ") "Change in enthalpy during isothermal process";
Real delta_H2(unit = "kJ") "Change in enthalpy during constant pressure process";
Real Q(unit = "kJ") "Heat transferred in the coils";

//============
//Equation Section
equation
//Step 1: Pressure drop at const. temperature of 293 K
//Step 2: Gas is heated from 293 K to 453 K at const. pressure of 136.8 kPa
delta_H1 = 0; //Step 1 change is enthalpy is zero due to const. Temperature
delta_H2 = ((m/M)*Cp*(T2-T1))/10^3;   
Q = delta_H1+delta_H2;    //Neglecting the kinetic and potential energy changes 

end Ex2_16;

//

//===================================================


