//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.3 Page 28
//Title: Heat dissipated by brakes
//===================================================

model Ex2_3

//============
//Parameter Section
parameter Real u(unit ="m/s") = 20 "Speed of the car";
parameter Real z(unit = "m") = 30 "Height vertically above the bottom of a hill";
parameter Real m(unit = "kg") = 1400 "Mass of the car";
parameter Real g(unit = "m/s^2") = 9.81 "Accleration due to gravity";

//============
//Variable Section
Real delta_KE(unit = "J") "Change in kinetic energy";
Real delta_PE(unit = "J") "Change in potential energy";
Real Q(unit = "J") "Heat dissipated by the brakes";

//============
//Equation Section
equation
delta_KE = -(1/2*m*u^2);
delta_PE = -(m*g*z);
Q = -( delta_KE + delta_PE);

end Ex2_3;

//===================================================
