//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 2: First Law of Thermodynamics
//Example: 2.9 Page 33
//Title: Molar internal energy and  enthalpy change 
//===================================================

model Ex2_9

//============
//Parameter Section
parameter Real I(unit = "A") = 0.5 "Electric current";
parameter Real V(unit = "V") = 12 "Voltage";
parameter Real t(unit = "min") = 5 "Time";
parameter Real P(unit = "atm") = 1 "Pressure";
parameter Real m(unit = "g") = 0.798 "Mass of water vapourised";
parameter Real T(unit = "K") = 373 "Temperature of sat. water at 1 atm";
parameter Real R(unit = "J/mol.K") = 8.314 "Ideal gas constant";
parameter Real M(unit = "g/mol") = 18 "Molar mass of water";

//============
//Variable Section
Real E(unit = "kJ") "Electric energy supplied";
Real delta_H(unit = "kJ/mol") "Molar enthalpy change";
Real delta_U(unit = "kJ/mol") "Molar internal energy change";

//============
//Equation Section
equation
E = (I*V)*(t*60)/10^3;
delta_H = (E/m)*M ;         //Heat supplied to the water equals the change in its enthalpy 
delta_U = delta_H-((R/10^3)*T);   //Const. P process delta_H = delta_U + P*delta_V

end Ex2_9;

//===================================================
