//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.1 Page 52
//Title: Molar volume of air
//===================================================

model Ex3_1

//============
//Parameter Section
parameter Real T(unit = "K") = 350 "Temperature of air";
parameter Real P(unit = "bar") = 1 "Pressure of air";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//=============
//Variable Section
Real V(unit = "m^3/mol") "Molar volume of air";

//============
//Equation Section
equation
V = (R*T)/(P*10^5);   //Ideal gas law, converting pressure from bar to Pascal

end Ex3_1;

//===================================================
