//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.4 Page 58
//Title: Change in Internal energy, Enthalpy, Heat, and Work effects in various processes
//===================================================

package Ex3_4
model Ex3_4_a
  
  //============
  //Parameter Section
  parameter Real P1(unit = "bar") = 5 "Initial pressure";
  parameter Real P2(unit = "bar") = 4 "Final pressure";
  parameter Real T(unit = "K") = 600 "Temperature";
  parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
  
  //============
  //Variable Section
  Real Q(unit = "kJ/kmol") "Heat supplied during the process";
  
  //============
  //Equation Section
  equation
  //For isothermal process, change in internal energy and enthalpy are zero
  Q = (R*T)*log(P1/P2);   //Since delta_U = 0, W=Q
  
  end Ex3_4_a;
    //============
  model Ex3_4_b
  
  //============
  //Parameter Section
  parameter Real V(unit = "m^3") = 0.1 "Volume of the container";
  parameter Real P(unit = "bar") = 1 "Pressure";
  parameter Real T1(unit = "K") = 298 "Initial Temperature";
  parameter Real T2(unit = "K") = 400 "Final Temperature";
  parameter Real Cp(unit = "J/mol K") = 30 "Heat capacity at const. pressure";
  parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";
  
  //============
  //Variable Section
  Real n(unit = "mol") "Moles of gas in the container";
  Real Cv(unit = "J/mol K") "Heat capacity at const. volume";
  Real delta_U(unit = "J") "Change in internal energy";
  Real delta_H(unit = "J") "Change in enthalpy";
  Real Q(unit = "J") "Heat supplied";
  
  //============
  //Equation Section
  equation 
  n = (P*10^5*V)/(R*T1);    //Converting pressure from bar to Pa
  Cv = Cp-R;
  delta_U = n*Cv*(T2-T1);
  delta_H = n*Cp*(T2-T1);
  Q = delta_U;    //Const. volume process, W=0
  
  end Ex3_4_b;
  
    //Answer may slightly vary due to rounding off values

//============

end Ex3_4;
