//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.5 Page 59
//Title: Work done and heat transferred
//===================================================

package Ex3_5

model Ex3_5_a

//============
//Parameter Section
parameter Real m(unit = "kg") = 20 "Mass of air";
parameter Real P1(unit = "bar") = 1 "Initial pressure";
parameter Real T1(unit = "K") = 300 "Initial temperature";
parameter Real P2(unit = "bar") = 5 "Final pressure";
parameter Real n(unit = "-") = 1.25 "Polytropic constant";
parameter Real M(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Setion
Real na(unit = "kmol") "Moles of air";
Real V1(unit = "m^3") "Initial volume of air";
Real V2(unit = "m^3") "Final volume of air";
Real C(unit = "-") "Constant";
Real W(unit = "kJ") "Work required by the compressor";

//============
//Equation Section
equation
na = m/M;
V1 = (na*10^3*R*T1)/(P1*10^5);   //Ideal gas law, converting kmol to mol and bar to Pa
V2 = V1*(P1/P2)^(1/n);    //Polytropic process
C = (P1*10^5)*V1^n;
W = (C/(1-n)*(V2^(1-n)-V1^(1-n)))/10^3;   //Converting J to kJ

end Ex3_5_a;

//============

model Ex3_5_b

extends Ex3_5_a;

//============
//Variable Section
Real T2(unit = "K") "Final temperature";
Real delta_U(unit = "kJ") "Change in internal energy";
Real Q(unit = "kJ") "Heat transferred to the surroundings";

//============
//Equation Section
equation
T2 = T1*(P2/P1)*(V2/V1);
//Cp = 27.4528+(6.1839*10^-3*T)-(8.9932*10^-7*T^2)
delta_U = ((27.4528*(T2-T1)+(6.1839/(2*10^3)*(T2^2-T1^2))-(8.9932/(3*10^7)*(T2^3-T1^3)))-R*(T2-T1))*(na);
                      //Cv = Cp-R
Q = delta_U+W;      //First law of thermodynamics

end Ex3_5_b;



end Ex3_5;
