//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 3: P-V-T Behaviour and Heat Effects
//Example: 3.6 Page 62
//Title: Ideal gas and van der Waals equation
//===================================================
package Ex3_6

model Ex3_6_a

//============
//Parameter Section
parameter Real n(unit = "kmol") = 1 "Mole of carbon dioxide";
parameter Real V(unit = "m^3") = 0.381 "Volume occupied by carbon dioxide";
parameter Real T(unit = "K") = 313 "Temperature";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real nV(unit = "m^3/mol") "Molar volume of carbon dioxide";
Real P(unit = "bar") "Pressure by ideal gas equation";

//============
//Equation Section
equation
nV = V/(n*10^3);
P =((R*T)/(nV))/10^5;

end Ex3_6_a;

//============

model Ex3_6_b

extends Ex3_6_a;

//============
//Parameter Section
parameter Real a(unit = "Nm^4/mol^2")  = 0.365 "van der Waals constant";
parameter Real b(unit = "m^3/mol") = 4.28/10^5 "van der Waals constant";

//============
//Variable Section
Real P1(unit = "bar") "Pressure by van der Waals equation";

//============
//Equation Section
equation
P1 = (((R*T)/(nV-b))-(a/nV^2))/10^5;

end Ex3_6_b;

end Ex3_6;
