//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.12 Page 107
//Title: Isothermal mixing of ideal gases
//===================================================

model Ex4_12

//============
//Parameter Section
parameter Real n1(unit = "%") = 21 "Percentage of oxygen in air";
parameter Real n2(unit = "%") = 79 "Percentage of nitrogen in air";
parameter Real n(unit = "kmol") = 1 "Moles of air";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real delta_S(unit = "kJ/kmol K") "Change in entropy";

//============
//Equation Section
equation
delta_S = -R*(n1*0.01*(log(n1*0.01))+ n2*0.01*(log(n2*0.01)));

end Ex4_12;

//===================================================
