//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.17 Page 114
//Title: Change in entropy of the system
//===================================================

model Ex4_17

//============
//Parameter Section
parameter Real V(unit = "m^3") = 1 "Volume of insulated tanks";
parameter Real T1(unit = "K") = 300 "Temperature of ideal gas in 1st tank";
parameter Real P1(unit = "kPa") = 200 "Pressure of ideal gas in 1st tank";
parameter Real P2(unit = "kPa") = 100 "Pressure of the system after mixing";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//===========
//Variable Section
Real n(unit = "kmol") "Quantity of gas";
Real delta_S(unit = "kJ/K") "Total change in entropy";

//============
//Equation Section
equation
n = (P1*V)/(R*T1);    //Ideal gas law
//Entropy of the surroundings doesn't change
delta_S = n*R*log(P1/P2);   //Ref. Eq. 4.33 pg no. 105

end Ex4_17;

//===================================================
