//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.7 Page 105
//Title: Change in entropy
//===================================================

model Ex4_7

//==============
//Parameter Section
parameter Real m(unit = "kg") = 2 "Mass of the gas";
parameter Real T1(unit = "K") = 277 "Initial temperature of the gas";
parameter Real T2(unit = "k") = 368 "Final temperature of the gas";
parameter Real Cv(unit = "kJ/kg K") = 1.42 "Specific heat at const. volume";

//=============
//Variable Section
Real delta_S(unit = "kJ/K") "Change in entropy";

//=============
//Equation Section
equation
delta_S = (m*Cv*log(T2/T1));

end Ex4_7;

//===================================================
