//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 4: Second Law of Thermodynamics
//Example: 4.9 Page 105
//Title: Change in entropy
//===================================================

model Ex4_9

//==============
//Parameter Section
parameter Real n(unit = "kmol") = 1 "Moles of ideal gas";
parameter Real T1(unit = "K") = 335 "Initial temperature of the gas";
parameter Real P1(unit = "bar") = 10 "Initial pressure of the gas";
parameter Real T2(unit = "K") = 300 "Final temperature of the gas";
parameter Real P2(unit = "bar") = 1 "Final pressure of the gas";
parameter Real Cp(unit = "kJ/kmol K") = 29.3 "Specific heat at const. pressure";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//===============
//Variable Section
Real delta_S(unit = "kJ/kmol K") "Change in entropy";

//===============
//Equation Section
equation
delta_S = (Cp*log(T2/T1))-(R*log(P2/P1));

end Ex4_9;

//===================================================
