//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.11 Page 149
//Title: Temperature of gas and work required for compression
//===================================================

model Ex5_11

//==========
//Parameter Section
parameter Real P1(unit = "bar") =  1 "Initial pressure of the gas";
parameter Real T1(unit = "K") = 300 "Initial temperature of the gas";
parameter Real P2(unit = "bar") = 10 "Final pressure of the gas";
parameter Real V1(unit = "m^3/h") = 100 "Volumetric flow rate of the gas";
parameter Real gamma(unit = "-") = 1.3 "Ratio of specific heats";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real Ws(unit = "kW") "Work required for compression";
Real T2(unit = "K") "Final temperature of the gas";

//===========
//Equation Section
equation
Ws = -((gamma/(gamma-1))*P1*10^2*(V1/3600)*(1-(P2/P1)^((gamma-1)/gamma)));    //From Eqn. 5.46
T2 = T1*(P2/P1)^((gamma-1)/gamma);    //For adiabatic compression

end Ex5_11;

//===================================================
