//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.12 Page 150
//Title: Work requirement for two-stage compressor
//===================================================

model Ex5_12

//===========
//Parameter Section

parameter Real M(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real P1(unit = "Pa") =  10^5 "Initial pressure of the gas";
parameter Real T1(unit = "K") = 300 "Initial temperature of the gas";
parameter Real P2(unit = "Pa") = 3.6*10^6 "Final pressure of the gas";
parameter Real N(unit = "-") = 2 "No.of stages in compression";
parameter Real n(unit = "-") = 1.3 "Polytropic exponent";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section 
Real P(unit = "Pa") "Optimum interstage pressure";
Real r(unit = "-") "Compression ratio";
Real Ws(unit = "kJ") "Work of compression";

//===========
//Equation Section
equation
P = sqrt(P1*P2);
r = P/P1;
Ws = -(((N*n)/(n-1))*R*T1*(1-(r^((n-1)/n))))/M;

end Ex5_12;

//Answer provided in the textbook is wrong for work of compression

//===================================================
