//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.17 Page 158
//Title: Vapour compression refrigeration
//===================================================

model Ex5_17

//============
//Parameter Section
parameter Real Tci(unit = "K") = 288 "Inlet temperature of cooling water";
parameter Real mc(unit = "kg/s") = 0.25 "Mass flow rate of cooling water";
parameter Real Tco(unit =  "K") = 300 "Outlet temperature of cooling water";
parameter Real T(unit = "K") = 294 "Temperature of ammonia";
parameter Real m(unit = "kg/min") = 0.5 "Rate of condensation of ammonia";
parameter Real HD(unit =  "kJ/kg") = 281.5 "Enthalpy of liquid ammonia at 294 K";
parameter Real eta(unit = "-") = 0.9 "Efficiency of compressor";
parameter Real HA(unit = "kJ/kg") = 1426 "Enthalpy of sat. ammonia vapour at 258 K";
parameter Real Cp(unit = "kJ/kg K") = 4.2 "Specific heat of water";

//===========
//Variable Section
Real Q1(unit = "kJ/s") "Heat rejected in the condenser at const. pressure";
Real Q2(unit = "kJ/s") "Heat absorbed";
Real W(unit = "kJ/s") "Work required by compressor";
Real P(unit = "hp") "Power requirement of the compressor";
Real C(unit = "ton") "Refrigeration capacity";

//===========
//Equation Section
equation
Q1 = mc*Cp*(Tco-Tci);
Q2 = (m/60)*(HA-HD);
W = Q1-Q2;
P = (W/eta)/0.746;    //Converting kW to hp
C = (Q2*3600)/12660;    //1 ton of refrigeration is equivalent to 12660 kJ/h

end Ex5_17;

//===================================================
