//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.19 Page 162
//Title: Air-refrigeration
//===================================================

model Ex5_19

//=============
//Parameter Section
parameter Real  r(unit = "ton") = 10 "Refrigeration capacity";
parameter Real T2(unit = "K") = 261 "Temperature of cold room";
parameter Real T1(unit = "K") = 293 "Temperature of cooling water";
parameter Real P2(unit = "bar") = 1.013 "Low pressure";
parameter Real P1(unit = "bar") = 4.052 "High pressure";
parameter Real T(unit = "K") = 5 "Approach temperature";
parameter Real Cp(unit = "kJ/kg K") = 1.008 "Specific heat of air";
parameter Real gamma(unit = "-") = 1.4 "Ratio of specific heats";

//============
//Variable Section
Real TA(unit = "K") "Temperature of air leaving the refrigerator";
Real TB(unit = "K") "Temperature of air leaving the compressor";
Real TC(unit = "K") "Temperature of air leaving the cooler";
Real TD(unit = "K") "Temperature of air leaving the expander";
Real COP(unit = "-") "Coefficient of performance";
Real m(unit = "kg/h") "Air-circulation rate";

//============
//Equation Section
equation
TA = T2-T;
TC = T1+T;
TB = TA*((P1/P2)^((gamma-1)/gamma));    //Adiabatic process
TD = TC*((P2/P1)^((gamma-1)/gamma));
COP = TA/(TB-TA);   //Using Eqn. 5.68 pg no. 162
m = (r*12660)/(Cp*(TA-TD));   //1 ton of refrigeration is equivalent to 12660 kJ/h

end Ex5_19;

//===================================================
