//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.20 Page 165
//Title: Heat pumps
//===================================================

model Ex5_20

//============
//Parameter Section
parameter Real C(unit = "kW") = 1 "Capacity of heat pump";
parameter Real W(unit = "kJ") = 1 "Net work input";
parameter Real T1(unit = "K") = 300 "Indoor temperature";
parameter Real T2(unit = "K") = 290 "Outside temperature";

//============
//Variable Section
Real Q2(unit = "kJ") "Heat absorbed";
Real Q1(unit = "kJ") "Heat rejected";

//============
//Equation Section
equation
Q2 = W*(T2/(T1-T2));
Q1 = Q2+W;

end Ex5_20;

//===================================================s
