//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.22 Page 169
//Title: Isenthalpic expansion
//===================================================

package Ex5_22

model Ex5_22_a

//============
//Parameter Section
parameter Real P1(unit = "bar") = 2.54 "Inlet pressure of steam";
parameter Real P2(unit = "bar") = 1 "Pressure of superheated steam";
parameter Real T2(unit = "K") = 385 "Temperature of superheated steam";
//Data from steam tables,
parameter Real Hv1(unit = "kJ/kg") = 2717 "Enthalpy of sat. vapour at 2.54 bar";
parameter Real Hl1(unit = "kJ/kg") = 538 "Enthalpy of sat. liquid at 2.54 bar";
parameter Real H2(unit = "kJ/kg") = 2700 "Enthalpy of superheated steam at 1 bar and 385 K";

//===========
//Variable Section
Real x(unit = "-") "Fraction of inlet which is liquid";

//===========
//Equation Section
equation
(x*Hl1)+((1-x)*Hv1) = H2;    //Enthalpy balance around  the throttle valve

//Temperature of inlet steam is 401 K from the steam tables.

end Ex5_22_a;

end Ex5_22;

//===================================================
