//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 5: Some Applications of the Laws of Thermodynamics
//Example: 5.8 Page 140
//Title: Flow through nozzzles
//===================================================

package Ex5_8

model Ex5_8_a

//==========
//Parameter Section
parameter Real To(unit = "K") =  600 "Inlet temperature of the air";
parameter Real Po(unit = "'kPa") = 2000 "Inlet pressure of the air";
parameter Real gamma(unit = "-") = 1.4 "Ratios of the specific heats";
parameter Real M(unit = "-") = 0.8 "Mach number";
parameter Real MW(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real R(unit = "J/kmol K") = 8314 "Universal gas constant";

//==========
//Variable Section
Real P(unit = "kPa") "Pressure at the throat";
Real T(unit ="K") "Temperature at the throat";
Real u(unit = "m/s") "Velocity at the throat";
Real rho_o(unit = "kg/m^3") "Density of the inlet";
Real rho(unit = "kg/m^3") "'Density at the throat";

//==========
//Equation Section
equation
P = Po/(1+(((gamma-1)/2)*M^2))^(gamma/(gamma-1));   //Rearranging Eqn. 5.39 Ref pg no. 139
u^2 = ((2*gamma*(R*To/MW))/(gamma-1))*(1-(P/Po)^((gamma-1)/gamma));   //From Eqn. 5.39 Ref pg no. 139
T = To*((P/Po)^((gamma-1)/gamma));    //From Eqn. 3.23 for adiabatic process
rho_o = (Po*MW)/(R/10^3*To);
rho = rho_o*((P/Po)^(1/gamma));

end Ex5_8_a;

model Ex5_8_b

extends Ex5_8_a;

//=========
//Variable Section
Real Pc(unit = "kPa") "Critical pressure";

//=========
//Equation Section
equation
Pc = Po*(2/(gamma+1))^((gamma)/(gamma-1));    //From Eqn. 5.42 Ref pg no. 139

end Ex5_8_b;

end Ex5_8;
