//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 6: Thermodynamic Properties of Pure Fluids
//Example: 6.26 Page 252
//Title: Fugacity of pure ethylene
//===================================================

model Ex6_26


//============
//Parameter Section
parameter Real P(unit = "bar") = 100 "Pressure";
parameter Real T(unit = "K") = 373 "Temperature";
parameter Real a(unit = "m^3/mol^2") = 0.453 "van der Waals constant";
parameter Real b(unit = "m^3/mol") = 0.571/10^4 "van der Waals constant";
parameter Real V(unit = "m^3/mol") = 2.072/10^4 "Molar volume at 100 bar and 373 K";
parameter Real R(unit = "J/mol K") = 8.314 "Universal gas constant";

//============
//Variable Section
Real f(unit = "bar") "Fugacity of pure ethylene";

//===========
//Equation Section
equation
log(f) = (b/(V-b))-((2*a)/(R*T*V))+log(((R*T)/(V-b))/10^5);   //Using Eqn. 6.139 pg no. 252

end Ex6_26;

//===================================================
