package Ex6_9
  //Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
  //Chapter 6: Thermodynamic Properties of Pure Fluids
  //Example: 6.9 Page 224
  //Title: Entropy and mean heat capacity
  //===================================================

  model Ex6_9_a
  
    //===========
    //Parameter Section
    parameter Real Cp(unit = "J/mol K") = 33.6 "Mean specific heat at atmospheric pressure";
    parameter Real A(unit = "K/bar mol") = 1 / 10 ^ 3 "Constant";
    parameter Real B(unit = "m^3/mol") = 8 / 10 ^ 5 "Constant";
    parameter Real P1(unit = "bar") = 4 "Initial pressure";
    parameter Real T1(unit = "K") = 300 "Initial temperature";
    parameter Real P2(unit = "bar") = 12 "Final pressure";
    parameter Real T2(unit = "K") = 400 "Final temperature";
    parameter Real P3(unit = "bar") = 1 "Intermediate pressure";
    parameter Real R(unit = "m^3(bar)/mol K") = 8.314 / 10 ^ 5 "universal gas constant";
    //===========
    //Variable Section
    Real delta_S1(unit = "J/mol K") "Change in entropy for step 1";
    Real delta_S2(unit = "J/mol K") "Change in entropy for step 2";
    Real delta_S3(unit = "J/mol K") "Change in entropy for step 3";
    Real delta_S(unit = "J/mol K") "Change in entropy for the actual process";
    //===========
    //Equation Section
  equation
//Step 1: Process AC, isothermal at 300 K
    delta_S1 = (R * log(P1 / P3) - A * (P1 ^ 2 - P3 ^ 2) / (2 * T1 ^ 2)) * 10 ^ 5;
//Integral equation
//Step 2: Process CD, isobaric at 1 bar";
    delta_S2 = Cp * log(T2 / T1);
//Integral equation
//Step 3: Process DB, isothermal at 400 K
    delta_S3 = (R * log(P3 / P2) - A * (P3 ^ 2 - P2 ^ 2) / (2 * T2 ^ 2)) * 10 ^ 5;
    delta_S = delta_S1 + delta_S2 + delta_S3;
//Integral equation
  end Ex6_9_a;

  //===========

  model Ex6_9_b
  
  extends Ex6_9_a;
  
  //===========
  //Variable Section
  Real Cpm(unit = "J/mol K") "Mean heat capacity at 12 bar";
  
  //===========
  //Equation Section
  equation
  -(((R*log(P2/P1))-((A*(P2^2-P1^2))/(2*T1^2)))) + ((Cpm/10^5)*log(T2/T1)) = (delta_S/10^5);
  
  end Ex6_9_b;
end Ex6_9;
