//Narayanan, K. V.,A Textbook of Chemical Engineering Thermodynamics,2nd edn.,PHI Learning Pvt Ltd.,2013
//Chapter 7: Properties of Solutions
//Example: 7.10 Page 294
//Title: Henry's law and gas solubility
//===================================================

model Ex7_10

//============
//Parameter Section
parameter Real T(unit = "K") = 298 "Temperature of the solution";
parameter Real Ki(unit = "bar") = 4.4*10^4 "Henry's law constant";
parameter Real pi(unit = "bar") = 0.25 "Partial pressure of oxygen";
parameter Real M_O2(unit = "kg/kmol") = 32 "Molar mass of oxygen";
parameter Real M_H2O(unit = "kg/kmol") = 18 "Molar mass of water";


//============
//Variable Section
Real xi(unit = "moles/mole of water") "Solubility of oxygen";
Real x_O2(unit = "kg oxygen/kg water") "Solubility in mass units";

//=============
//Equation Section
equation
xi = pi/Ki;   //Henry's law
x_O2 = (xi*M_O2)/M_H2O;

end Ex7_10;

//===================================================
